
######################################################
######## BALANCE CHECK USING RItools, All Characteristics ############
######################################################

rm(list=ls())
library(RItools)

setwd("C:/Data/Dropbox/Research/2014- Deliberative Polling/Analysis/")

dat = read.csv("Composition.csv", header=TRUE)
used = which(colnames(dat) %in% c("site","female","young","nocollege","nonwhite","prop_female","prop_young","prop_nocollege","prop_nonwhite"))

dat = dat[,used]

##female
bal.female = xBalance(prop_female~ female+young+nonwhite+nocollege, strata=data.frame(site=factor(dat$site)), data=dat, 
         report=c("chisquare.test","std.diffs","z.scores","p.values"))

##young
bal.young = xBalance(prop_young~ female+young+nonwhite+nocollege, strata=data.frame(site=factor(dat$site)), data=dat, 
         report=c("chisquare.test","std.diffs","z.scores","p.values"))

##nonwhite
bal.nonwhite = xBalance(prop_nonwhite~ female+young+nonwhite+nocollege, strata=data.frame(site=factor(dat$site)), data=dat, 
         report=c("chisquare.test","std.diffs","z.scores","p.values"))

##nocollege
bal.nocollege = xBalance(prop_nocollege~ female+young+nonwhite+nocollege, strata=data.frame(site=factor(dat$site)), data=dat, 
         report=c("chisquare.test","std.diffs","z.scores","p.values"))

		 
bal.female
bal.young
bal.nonwhite
bal.nocollege

